#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

struct Point {
    long long x,y;
};
struct Vox {
    long long x,y;
    void init(Point a,Point b) {
        x=b.x-a.x;
        y=b.y-a.y;
    }
};
long long cross(Vox a,Vox b) {
    return a.x*b.y-a.y*b.x;
}
long long dot(Vox a,Vox b) {
    return a.x*b.x+a.y*b.y;
}
vector <pair<Point,Point>> a;
bool isIns(int i,int j) {
    Point A,B,C,D,O;
    O.x=0;
    O.y=0;
    A.x=a[i].first.x-a[j].first.x;
    A.y=a[i].first.y-a[j].first.y;
    B.x=a[i].second.x-a[j].first.x;
    B.y=a[i].second.y-a[j].first.y;
    C.x=a[i].second.x-a[j].second.x;
    C.y=a[i].second.y-a[j].second.y;
    D.x=a[i].first.x-a[j].second.x;
    D.y=a[i].first.y-a[j].second.y;
    Vox v1,v2,v3,v4,Vs1,Vs2,Vs3,Vs4;
    v1.init(A,B);
    v2.init(B,C);
    v3.init(C,D);
    v4.init(D,A);
    Vs1.init(A,O);
    Vs2.init(B,O);
    Vs3.init(C,O);
    Vs4.init(D,O);
    return (cross(v1,Vs1)>=0 && cross(v2,Vs2)>=0 && cross(v3,Vs3)>=0 && cross(v4,Vs4)>=0) || (cross(v1,Vs1)<=0 && cross(v2,Vs2)<=0 && cross(v3,Vs3)<=0 && cross(v4,Vs4)<=0);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    Point a1,a2,b1,b2;
    int _;
    cin >> _;
    for (int __=0;__<_;__++) {
        int n;
        cin >> n;
        a.resize(n);
        for (int i=0;i<n;i++) {
            cin >> a[i].first.x >> a[i].first.y >> a[i].second.x >> a[i].second.y;
            if (a[i].first.x>a[i].second.x) swap(a[i].first,a[i].second);
        }
        long long ans=0;
        for (int i=0;i<n;i++) {
            for (int j=i+1;j<n;j++) {
                if (isIns(i,j)) {
                    for (int k=j+1;k<n;k++) {
                        if (isIns(i,k) && isIns(j,k)) {
                            ans++;
                        }
                    }
                }
            }
        }
        cout << ans+1 << "\n";
    }
}
